'use strict';

/* --------------------------------------------------------------
 initialize.js 2018-04-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Admin Layout Initialization Controller
 *
 * This controller will handle the initialization of the admin pages. Bind this controller
 * in the body element of the page.
 */
gx.controllers.module('initialize', ['hooks'], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $('body').on('JSENGINE_INIT_FINISHED', function () {
            $this.fadeIn(200, function () {
                $this.removeClass('page-loading');
            });
        });

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
